import argparse
from typing import List

import runner
from runner import ProcessCmd


def execute(ht_reference: str, extras: List[str]):
    ref_name = '.'.join(ht_reference.split('/')[-1].split('.')[0:-1])
    process_cmds = [
        ProcessCmd('/opt/edico/bin/dragen --partial-reconfig HMM --ignore-version-check true'),
        ProcessCmd(
            ' '.join([
                '/opt/edico/bin/dragen --build-hash-table true --output-directory reference',
                f'--ht-reference {ht_reference}',
                *extras
            ]),
            'reference'
        ),
        ProcessCmd(f'tar -cf {ref_name}.tar -C reference .'),
    ]
    runner.run_dragen_cmds(process_cmds)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--ht-reference')
    parser.add_argument('--debug', action='store_true')
    args, extras = parser.parse_known_args()
    runner.execute_with_no_traceback(
        lambda: execute(args.ht_reference, extras),
        args.debug
    )


if __name__ == '__main__':
    main()
