from typing import List
from unittest.mock import MagicMock

import ref_builder
from runner import ProcessCmd


def test_when_passed_reference__correctly_names_tar_file():
    ref_builder.runner = MagicMock()
    ref_builder.execute('/my/folder/myFavoriteGenome.fasta', ['--arg1', 'val1', '--arg2', 'val2'])

    args: List[ProcessCmd] = ref_builder.runner.run_dragen_cmds.call_args.args[0]
    assert len(args) == 3
    assert '--ht-reference /my/folder/myFavoriteGenome.fasta' in args[1].cmd
    assert '--arg1 val1 --arg2 val2' in args[1].cmd
    assert 'tar -cf myFavoriteGenome.tar -C reference .' in args[2].cmd
