from typing import List
from unittest.mock import patch, MagicMock

import pytest

import somatic_runner
from runner import ProcessCmd
from test_utils import assert_args


@patch('builtins.open')
def test_when_tumor_normal_pair_passed__correctly_invokes_dragen(mock_open):
    somatic_runner.runner.run_dragen_cmds = MagicMock()
    somatic_runner.execute_somatic(
        '/my/folder/reference.tar',
        ['--foo', 'bar', '--baz', 'abc'],
        tumor_fastqs=[
            "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187C_S1_L001_R1_001.fastq.gz",
            "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187C_S1_L001_R2_001.fastq.gz",
        ],
        normal_fastqs=[
            "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187BL_S1_L001_R1_001.fastq.gz",
            "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187BL_S1_L001_R2_001.fastq.gz",
        ]
    )

    cmds: List[ProcessCmd] = somatic_runner.runner.run_dragen_cmds.call_args.args[0]
    assert len(cmds) == 3
    assert cmds[1].cmd == 'tar -C /ephemeral/reference/index -xf /my/folder/reference.tar'
    assert cmds[1].working_dir == '/ephemeral/reference/index'
    assert_args([
        '--output-directory .',
        '--foo bar ',
        '--baz abc',
        '--tumor-fastq-list-sample-id HCC1187C_S1',
        '--tumor-fastq-list',
        '--fastq-list-sample-id HCC1187BL_S1',
        '--fastq-list',
    ], cmds[2].cmd)


@patch('builtins.open')
def test_when_multiple_samples_passed__correctly_raises_exception(mock_open):
    somatic_runner.runner.run_dragen_cmds = MagicMock()
    with pytest.raises(ValueError) as e:
        somatic_runner.execute_somatic(
            '/my/folder/reference.tar',
            ['--foo', 'bar', '--baz', 'abc'],
            tumor_fastqs=[
                "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187C_S1_L001_R1_001.fastq.gz",
                "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187C_S1_L001_R2_001.fastq.gz",
                "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187BL_S1_L001_R1_001.fastq.gz",
                "/Illumina Public DRAGEN Somatic Data/DRAGEN Somatic Input/HCC1187BL_S1_L001_R2_001.fastq.gz",
            ],
            normal_fastqs=[]
        )

    assert str(e.value) == ('Only one sample can be submitted at a time, and the files must match the convention, ' +
                            '(.+_S[0-9]+)_L([0-9]{3})_R([1-2])_([0-9]{3})$ where sample name is group 1.')
